/*************************************************************************
 *
 * Hitchhiker's Guide to the IBM PE 
 * Series Evaluation - parallel version
 * Chapter 2 - The Answer is 42
 *
 * To compile:
 * mpcc -g -o series_parallel series_parallel.c -lm
 *
 *************************************************************************/

#include<stdlib.h>
#include<stdio.h>
#include<math.h>
#include<mpi.h>

double angle[] = { 0.0, 0.1*M_PI, 0.2*M_PI, 0.3*M_PI, 0.4*M_PI, 
	      0.5*M_PI, 0.6*M_PI, 0.7*M_PI, 0.8*M_PI, 0.9*M_PI, M_PI }; 

int main(int argc, char **argv)
{
  double data, divisor, partial, sine;
  int a, t, angles = sizeof(angle)/sizeof(angle[0]);
  int me, tasks, term;

  MPI_Init(&argc,&argv);       		/* Initialize MPI */
  MPI_Comm_size(MPI_COMM_WORLD,&tasks);	/* How many parallel tasks are there?*/
  MPI_Comm_rank(MPI_COMM_WORLD,&me);	/* Who am I? */

  term = 2*me+1;                        /* Each task computes a term */
  /* Scan the factorial terms through the group members   */
  /* Each member will effectively multiply the product of */
  /* the result of all previous members by its factorial  */
  /* term, resulting in the factorial up to that point    */
  if(me==0)
    data = 1.0;
  else
    data = -(term-1)*term;
  MPI_Scan(&data,&divisor,1,MPI_DOUBLE,MPI_PROD,MPI_COMM_WORLD);

  /* Compute sine of each angle */
  for(a=0;a<angles;a++)
    {
      partial = pow(angle[a],term)/divisor;
      /* Pass all the partials back to task 0 and   */
      /* accumulate them with the MPI_SUM operation */
      MPI_Reduce(&partial,&sine,1,MPI_DOUBLE,MPI_SUM,0,MPI_COMM_WORLD);
      /* The first task has the total value */
      if(me==0)
	{
	  printf("sin(%lf) + %lf\n",angle[a],sine);
	}
    }
  MPI_Finalize();
}
